'La liste des voitures peut tre trie
' sur la base du carID.
Public Class Car
    Implements IComparable

    ' Une classe imbrique !		
    Private Class SortByPetNameHelper
        Implements IComparer

        ' Implmentation de IComparer.
        Private Function Compare(ByVal o1 As Object, ByVal o2 As Object) As Integer _
            Implements IComparer.Compare
            Dim t1 As Car = CType(o1, Car)
            Dim t2 As Car = CType(o2, Car)
            Return String.Compare(t1.PetName, t2.PetName)
        End Function
    End Class

    ' Donnes d'tat.
    Private mCarID As Integer
    Private mPetName As String

    ' Proprits.
    Public Property ID() As Integer
        Get
            Return mCarID
        End Get
        Set(ByVal Value As Integer)
            mCarID = Value
        End Set
    End Property

    ' Proprits.
    Public Property PetName() As String
        Get
            Return mPetName
        End Get
        Set(ByVal Value As String)
            mPetName = Value
        End Set
    End Property

    ' Ensemble de constructeurs.
    Public Sub New()
    End Sub
    Public Sub New(ByVal id As Integer, ByVal name As String)
        mCarID = ID
        mPetName = name
    End Sub

    ' Implmentation de IComparable.
    Private Function CompareTo(ByVal o As Object) _
      As Integer Implements IComparable.CompareTo
        Dim temp As Car = CType(o, Car)
        If (Me.mCarID > temp.mCarID) Then
            Return 1
        ElseIf (Me.mCarID < temp.mCarID) Then
            Return -1
        Else
            Return 0
        End If
    End Function

    ' Proprit pour renvoyer la comparaison par nom.
    Public Shared ReadOnly Property SortByPetName() As IComparer
        Get
            Return New SortByPetNameHelper()
        End Get
    End Property

End Class
